﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Security.Cryptography.X509Certificates;
using CryptoCMP.CAInteraction;
using CryptoCMP;

namespace GenKeyCMP
{
    class Program
    {
        static void Main(string[] args)
        {
            // формирование с общий секретом
            CMPGenKey genkey = new CMPGenKey();
            genkey.secret = "1234567890";
            genkey.ID = "vogonova001";
            genkey.profile = "profile://OCSP_TEST";
            byte[] req = genkey.Generate(CryptoCMP.TumarKeyAlgID.ECGostSignature, CryptoCMP.TumarKeyAlgID.ECGostExchange);


            CryptoCMP.Utils.SendRequest send = new CryptoCMP.Utils.SendRequest();
            int err = 0;
            byte[] resp = send.SendMessage(5, "192.168.10.30", "62295", req, ref err);

            VerifyCMPResponce ver = new VerifyCMPResponce();
            ver.profile = "profile://OCSP_TEST";
            ver.secret = "1234567890";
            bool r = ver.Verify(resp, CpTumar.PKI_CMP_IP);

            // формирование без общего секрета
            CMPGenKey genKey2 = new CMPGenKey();
            genKey2.ID = "vogonova001";
            genKey2.profile = "profile://OCSP_TEST";          
            int[] algs = new int[3];
            algs[0] = CryptoCMP.TumarKeyAlgID.ECGostSignature;
            algs[1] = CryptoCMP.TumarKeyAlgID.ECGostExchange;
            algs[2] = CryptoCMP.TumarKeyAlgID.RSA1024Signature;
            byte[] req2 = genKey2.Generate(algs);

            err = 0;            
            byte[] resp2 = send.SendMessage(5, "192.168.10.30", "62295", req2, ref err);

            VerifyCMPResponce ver2 = new VerifyCMPResponce();
            ver2.profile = "profile://OCSP_TEST";
            r = ver2.Verify(resp2, CpTumar.PKI_CMP_CP);

            X509Certificate2[] certs = ver2.GetResponceCert(resp2, 0); //ext
            X509Certificate2[] certs2 = ver2.GetResponceCert(resp2, 1); /// user
            X509Certificate2[] certs3 = ver2.GetResponceCert(resp2, 2); // ca
        }
    }
}
